﻿/*
USAGE:
	#include "gameProgram/savegame.as"
	var result = saveGame( RAM, "gameName" );
*/
#include "gameFunctions/copyObject.as"
saveSettings = function( saveTo )
{
	var saveTo = saveTo || RAM;
	
	// annouce that the game is about to be saved
	ROOT.sendEvent("saveGame", {saveTo: saveTo} );
	
	// store current level
	saveTo.saveSettings = {};
	saveTo.saveSettings.level = ROOT.level_xml.filePath;

	// store player appearance
	if(SPRITES.player)
	{// if:  player exists
		var currentPlayer = SPRITES.player.image.getParams();
		if(currentPlayer)
			saveTo.playerSprite = currentPlayer;
		// store player location
		saveTo.saveSettings.playerPosition = {
			x:SPRITES.player._x,
			y:SPRITES.player._y
		}// playerPosition
	}// if:  player exists
	
	// store audio settings
	saveTo.saveSettings.music = {
		songName:MUSIC.songName,
		isPlaying:MUSIC.isPlaying,
		volume:MUSIC.volume,
		songVolume:MUSIC.songVolume
	}// music
	// NOTE:  looping sounds are NOT stored
	saveTo.saveSettings.sound = {
		volume:SOUND.volume
	}// sound
}// saveSettings()


/*	
function getSaveSettings(){
	var output = {};
	saveSettings( output );
	return output;
}// getSaveSettings()
*/


saveGame = function(inputData, gameId)
{
	var dataIsString = ( typeof(inputData) === "string" );
	if( dataIsString ){
		trace("Save Failed:  inputData was not an object,  it was this string:  '" + inputData + "'");
		return false;
	}
	
	
	// Save a COPY of the game's variables
	var saveData = {};
	copyObject(inputData, saveData);
	
	
	// Add to saved data:  level,  player appearance,  position,  music,  music + sfx volumes
	saveSettings( saveData );
	
	
	if(saveData)
	{
		// access saved data
		var gameId = gameId || "humbird0_rpg";
		gameId = gameId.split(" ").join("_");
		var srm = SharedObject.getLocal(gameId);
		// clear previous saved data
		srm.clear();
		// store data
		srm.data.ram = {};
		copyObject(saveData, srm.data.ram);
		// write data to disk now
		var success = srm.flush();
		
		if(success){
			trace("Save Successful");
			return true;
		}else{
			trace("Save Failed");
			return false;
		}
	}// if:  there's data to save
}// storeSave()